/**
 * blockService.js
 * Serviço para verificar bloqueios entre usuários.
 *
 * INTEGRAÇÃO:
 * - Substitua os stubs por consultas ao seu banco.
 * - Ex.: buscar na tabela "blocks" se (A bloqueou B) ou (B bloqueou A).
 */

class BlockService {
  /**
   * Retorna true se A bloqueia B ou B bloqueia A.
   * @param {number|string} userIdA
   * @param {number|string} userIdB
   * @returns {Promise<boolean>}
   */
  async isBlocked(userIdA, userIdB) {
    // TODO: plugue aqui sua verificação real no DB.
    // Exemplo de pseudo-código:
    // const r1 = await db.query('SELECT 1 FROM blocks WHERE blocker_id=? AND blocked_id=? LIMIT 1', [userIdA, userIdB]);
    // const r2 = await db.query('SELECT 1 FROM blocks WHERE blocker_id=? AND blocked_id=? LIMIT 1', [userIdB, userIdA]);
    // return (r1.length > 0 || r2.length > 0);

    return false; // padrão: sem bloqueio
  }

  /**
   * Checa se há QUALQUER conflito de bloqueio no conjunto da sala.
   * @param {Array<{userId:any, sessionId:string}>} users
   * @returns {Promise<{ hasConflict: boolean, pairs: Array<[any, any]> }>}
   */
  async hasAnyBlockingConflict(users) {
    const pairs = [];
    for (let i = 0; i < users.length; i++) {
      for (let j = i + 1; j < users.length; j++) {
        const a = users[i];
        const b = users[j];
        if (!a?.userId || !b?.userId) continue;

        // Checa bloqueio cruzado
        // (se qualquer lado bloqueia o outro, consideramos conflito)
        // eslint-disable-next-line no-await-in-loop
        const blocked = await this.isBlocked(a.userId, b.userId);
        if (blocked) {
          pairs.push([a.userId, b.userId]);
        }
      }
    }
    return { hasConflict: pairs.length > 0, pairs };
  }

 

}

module.exports = new BlockService();
