const express = require('express');
const router = express.Router();
const friendshipController = require('../controllers/friendshipController');
const authMiddleware = require('../middlewares/authMiddleware');
const { validate } = require('../middlewares/validationMiddleware');

// Todas as rotas protegidas
router.use(authMiddleware.requireAuth);

// Solicitações
router.post('/requests', validate('sendRequest'), friendshipController.sendFriendRequest);
router.put('/requests/:requestId', validate('respondRequest'), friendshipController.respondToFriendRequest); // body.action: 'accept' | 'reject' | 'cancel'
router.get('/requests', friendshipController.listFriendRequests);
router.get('/requests/count', friendshipController.countFriendRequests);

// Amigos
router.get('/friends', friendshipController.listFriends);
router.get('/friends/search', friendshipController.searchFriends);
router.delete('/friends/:friendId', friendshipController.removeFriend);

// Galeria (aplica bloqueio e visibilidade)
router.get('/galeria/:friendId', friendshipController.getGaleria);

// Status & Views
router.get('/status/:userId', friendshipController.checkFriendshipStatus);
router.get('/view/:friendId', friendshipController.viewFriendProfile);
router.get('/explorer/view/:friendId', friendshipController.viewExplorerProfile);

// Bloqueio
router.post('/blocks', validate('blockUser'), friendshipController.blockUser);
router.delete('/blocks/:userId', friendshipController.unblockUser);
router.get('/blocks', friendshipController.listBlockedUsers);
router.get('/is-blocked/:userId', friendshipController.checkIfBlocked);

module.exports = router;
