const express = require('express');
const router = express.Router();
const explorerController = require('../controllers/explorerController');
const authMiddleware = require('../middlewares/authMiddleware');

router.post('/settings', authMiddleware.requireAuth, explorerController.updateExplorerSettings);
router.get('/users', authMiddleware.requireAuth, explorerController.getExplorerUsers);


module.exports = router;