const express = require('express');
const router = express.Router();
const chatFriendsController = require('../controllers/chatFriendsController');
const authMiddleware = require('../middlewares/authMiddleware');

// Rotas protegidas por autenticação
router.use(authMiddleware.requireAuth);

router.get('/room', chatFriendsController.showRoom);

// Enviar mensagem
router.post('/send', chatFriendsController.sendMessage);

// Obter mensagens com um amigo específico
router.get('/messages/:friend_id', chatFriendsController.getMessages);
router.get('/friend/:friendId', chatFriendsController.getFriendData);
router.get('/friendship/:friendId', chatFriendsController.getFriendshipMeta);

// Marcar mensagens como lidas (as do amigo -> para o usuário logado)
router.post('/mark-read/:friendId', chatFriendsController.markAsRead);

// Contar não lidas vindas do amigo
router.get('/unread/:friendId', chatFriendsController.getUnreadCount);
router.get('/unread-total', chatFriendsController.getTotalUnread);

module.exports = router;
