// C:\src\Clientes\Datetime\models\tokenStore.js
const crypto = require('crypto');
const db = require('./db');

function sha256(input) {
  return crypto.createHash('sha256').update(input).digest('hex');
}

class TokenStore {
  async saveRefreshToken({ userId, refreshToken, expiresAt, ip, userAgent }) {
    const tokenHash = sha256(refreshToken);
    const sql = `
      INSERT INTO refresh_tokens (user_id, token_hash, expires_at, ip, user_agent)
      VALUES (?, ?, ?, ?, ?)
    `;
    await db.query(sql, [userId, tokenHash, expiresAt, ip || null, userAgent || null]);
    return tokenHash;
  }

  async findByToken(refreshToken) {
    const tokenHash = sha256(refreshToken);
    const sql = `SELECT * FROM refresh_tokens WHERE token_hash = ? LIMIT 1`;
    const rows = await db.query(sql, [tokenHash]);
    return rows[0] || null;
  }

  async markRevokedByHash(tokenHash, replacedByHash = null) {
    const sql = `
      UPDATE refresh_tokens
      SET revoked_at = NOW(), replaced_by_token_hash = ?
      WHERE token_hash = ? AND revoked_at IS NULL
    `;
    await db.query(sql, [replacedByHash, tokenHash]);
  }

  async revokeAllForUser(userId) {
    const sql = `UPDATE refresh_tokens SET revoked_at = NOW() WHERE user_id = ? AND revoked_at IS NULL`;
    await db.query(sql, [userId]);
  }
}

module.exports = new TokenStore();
module.exports.sha256 = sha256;
