// C:\src\Clientes\Datetime\controllers\geoController.js
async function safeFetchJson(url) {
  const r = await fetch(url);
  if (!r.ok) throw new Error(`Falha ao buscar: ${url}`);
  return r.json();
}

exports.states = async (_req, res, next) => {
  try {
    const data = await safeFetchJson('https://servicodados.ibge.gov.br/api/v1/localidades/estados?orderBy=nome');
    const out = data.map(s => ({ uf: s.sigla, nome: s.nome }));
    res.json({ success:true, items: out });
  } catch (e) { next(e); }
};

exports.cities = async (req, res, next) => {
  try {
    const uf = String(req.query.uf || '').toUpperCase();
    if (!uf) return res.status(400).json({ success:false, message:'UF ausente' });
    const data = await safeFetchJson(`https://servicodados.ibge.gov.br/api/v1/localidades/estados/${uf}/municipios?orderBy=nome`);
    const out = data.map(c => c.nome);
    res.json({ success:true, items: out });
  } catch (e) { next(e); }
};
