// errors.js
class AppError extends Error {
    constructor(message, status) {
        super(message);
        this.status = status;
        this.name = this.constructor.name;
        Error.captureStackTrace(this, this.constructor);
    }
}

class NotFoundError extends AppError {
    constructor(message = 'Recurso não encontrado') {
        super(message, 404);
    }
}

class ForbiddenError extends AppError {
    constructor(message = 'Acesso negado') {
        super(message, 403);
    }
}

class ConflictError extends AppError {
    constructor(message = 'Conflito de recursos') {
        super(message, 409);
    }
}

class BadRequestError extends AppError {
    constructor(message = 'Requisição inválida') {
        super(message, 400);
    }
}

module.exports = {
    AppError,
    NotFoundError,
    ForbiddenError,
    ConflictError,
    BadRequestError
};